/*
 * Decompiled with CFR 0.152.
 */
package com.zurrtum.create.client.compat.eiv;

import com.zurrtum.create.AllDataComponents;
import com.zurrtum.create.AllFluids;
import com.zurrtum.create.client.foundation.gui.AllGuiTextures;
import com.zurrtum.create.client.foundation.utility.CreateLang;
import com.zurrtum.create.content.fluids.potion.PotionFluidHandler;
import com.zurrtum.create.foundation.fluid.FluidIngredient;
import com.zurrtum.create.foundation.fluid.FluidStackIngredient;
import com.zurrtum.create.infrastructure.component.BottleType;
import com.zurrtum.create.infrastructure.fluids.FluidStack;
import de.crafty.eiv.common.api.recipe.IEivViewRecipe;
import de.crafty.eiv.common.recipe.ItemViewRecipes;
import de.crafty.eiv.common.recipe.inventory.RecipeViewMenu;
import de.crafty.eiv.common.recipe.inventory.SlotContent;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.function.UnaryOperator;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1844;
import net.minecraft.class_1887;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_3611;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9279;
import net.minecraft.class_9304;
import net.minecraft.class_9326;
import net.minecraft.class_9334;

@Environment(value=EnvType.CLIENT)
public abstract class CreateView
extends AbstractList<IEivViewRecipe>
implements IEivViewRecipe {
    public static final RecipeViewMenu.OptionalSlotRenderer SLOT = (context, x, y, pt) -> AllGuiTextures.JEI_SLOT.render(context, 0, 0);
    public static final RecipeViewMenu.OptionalSlotRenderer CHANCE_SLOT = (context, x, y, pt) -> AllGuiTextures.JEI_CHANCE_SLOT.render(context, 0, 0);
    public static final RecipeViewMenu.AdditionalStackModifier NOT_CONSUMED = (stack, tooltip) -> tooltip.add(1, CreateLang.translateDirect("recipe.deploying.not_consumed", new Object[0]).method_27692(class_124.field_1065));

    public void placeSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        int size = this.getViewType().getSlotCount();
        for (int i = this.placeViewSlots(slotDefinition); i < size; ++i) {
            slotDefinition.addItemSlot(i, 0, 0);
        }
    }

    public void bindSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        int size = this.getViewType().getSlotCount();
        for (int i = this.bindViewSlots(slotFillContext); i < size; ++i) {
            slotFillContext.bindOptionalSlot(i, SlotContent.of(), RecipeViewMenu.OptionalSlotRenderer.DEFAULT);
        }
    }

    protected int placeViewSlots(RecipeViewMenu.SlotDefinition slotDefinition) {
        return 0;
    }

    protected int bindViewSlots(RecipeViewMenu.SlotFillContext slotFillContext) {
        return 0;
    }

    public void bindChanceSlot(RecipeViewMenu.SlotFillContext slotFillContext, int i, SlotContent content, float chance) {
        class_5250 text = CreateLang.translateDirect("recipe.processing.chance", (double)chance < 0.01 ? "<1" : Integer.valueOf((int)(chance * 100.0f))).method_27692(class_124.field_1065);
        slotFillContext.bindOptionalSlot(i, content, CHANCE_SLOT);
        slotFillContext.addAdditionalStackModifier(i, (arg_0, arg_1) -> CreateView.lambda$bindChanceSlot$3((class_2561)text, arg_0, arg_1));
    }

    public boolean redirectsAsIngredient(class_1799 stack) {
        List ingredients;
        class_1792 item = stack.method_7909();
        return CreateView.matchPotion(item, stack, ingredients = this.getIngredients()) && CreateView.matchEnchantments(item, stack, ingredients);
    }

    public boolean redirectsAsResult(class_1799 stack) {
        List results;
        class_1792 item = stack.method_7909();
        return CreateView.matchPotion(item, stack, results = this.getResults()) && CreateView.matchEnchantments(item, stack, results);
    }

    private static boolean matchPotion(class_1792 item, class_1799 stack, List<SlotContent> slotContents) {
        class_1844 component = (class_1844)stack.method_58694(class_9334.field_49651);
        if (component == null) {
            return true;
        }
        class_6880 potion = component.comp_2378().orElse(null);
        BottleType bottleType = potion != null ? (BottleType)((Object)stack.method_58694(AllDataComponents.POTION_FLUID_BOTTLE_TYPE)) : null;
        for (SlotContent slotContent : slotContents) {
            for (class_1799 validStack : slotContent.getValidContents()) {
                if (!validStack.method_31574(item)) continue;
                class_1844 validComponent = (class_1844)validStack.method_58694(class_9334.field_49651);
                if (validComponent == null) {
                    return true;
                }
                if (!(potion == null ? validComponent.comp_2378().isEmpty() : validComponent.method_57401(potion) && (bottleType == null || validStack.method_58694(AllDataComponents.POTION_FLUID_BOTTLE_TYPE) == bottleType))) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matchEnchantments(class_1792 item, class_1799 stack, List<SlotContent> slotContents) {
        class_9304 enchantments = (class_9304)stack.method_58694(class_9334.field_49633);
        if (enchantments == null) {
            return true;
        }
        int size = enchantments.method_57541();
        Set entries = enchantments.method_57534();
        for (SlotContent slotContent : slotContents) {
            for (class_1799 validStack : slotContent.getValidContents()) {
                if (!validStack.method_31574(item)) continue;
                class_9304 validEnchantments = (class_9304)validStack.method_58694(class_9334.field_49633);
                if (validEnchantments == null) {
                    return true;
                }
                if (validEnchantments.method_57541() != size || !CreateView.matchEnchantments(entries, enchantments, validEnchantments)) continue;
                return true;
            }
        }
        return false;
    }

    private static boolean matchEnchantments(Set<class_6880<class_1887>> entries, class_9304 enchantments, class_9304 validEnchantments) {
        for (class_6880<class_1887> enchantment : entries) {
            if (validEnchantments.method_57536(enchantment) == enchantments.method_57536(enchantment)) continue;
            return false;
        }
        return true;
    }

    public static List<class_1799> getItemStacks(FluidIngredient ingredient) {
        List<class_3611> fluids = ingredient.getMatchingFluids();
        ArrayList<class_1799> list = new ArrayList<class_1799>(fluids.size());
        int amount = ingredient.amount();
        class_9326 components = null;
        if (ingredient instanceof FluidStackIngredient) {
            FluidStackIngredient stackIngredient = (FluidStackIngredient)ingredient;
            components = stackIngredient.components();
        }
        for (class_3611 fluid : fluids) {
            class_1792 item = ItemViewRecipes.INSTANCE.itemForFluid(fluid);
            if (item == class_1802.field_8162) continue;
            class_1799 stack = item.method_7854();
            if (components != null) {
                stack.method_57366(components);
                CreateView.updatePotionName(fluid, stack);
            }
            class_2487 tag = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
            tag.method_10569("fluidAmount", amount);
            stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
            list.add(stack);
        }
        return list;
    }

    public static class_1799 getItemStack(FluidStack fluidStack) {
        class_3611 fluid = fluidStack.getFluid();
        class_1792 item = ItemViewRecipes.INSTANCE.itemForFluid(fluid);
        if (item == class_1802.field_8162) {
            return class_1799.field_8037;
        }
        class_1799 stack = item.method_7854();
        stack.method_57365(fluidStack.method_57353());
        CreateView.updatePotionName(fluid, stack);
        class_2487 tag = ((class_9279)stack.method_58695(class_9334.field_49628, (Object)class_9279.field_49302)).method_57461();
        tag.method_10569("fluidAmount", fluidStack.getAmount());
        stack.method_57379(class_9334.field_49628, (Object)class_9279.method_57456((class_2487)tag));
        return stack;
    }

    private static void updatePotionName(class_3611 fluid, class_1799 stack) {
        if (fluid != AllFluids.POTION) {
            return;
        }
        class_1844 contents = (class_1844)stack.method_58695(class_9334.field_49651, (Object)class_1844.field_49274);
        BottleType bottleType = (BottleType)((Object)stack.method_58695(AllDataComponents.POTION_FLUID_BOTTLE_TYPE, (Object)BottleType.REGULAR));
        class_2561 name = contents.method_64195(PotionFluidHandler.itemFromBottleType(bottleType).method_7876() + ".effect.");
        stack.method_57379(class_9334.field_50239, (Object)name);
        if (!stack.method_57826(class_9334.field_55879) && bottleType == BottleType.LINGERING) {
            stack.method_57379(class_9334.field_55879, (Object)((Float)class_1802.field_8150.method_57347().method_58694(class_9334.field_55879)));
        }
    }

    @Override
    public int size() {
        return 1;
    }

    @Override
    public Iterator<IEivViewRecipe> iterator() {
        return new ViewIterator();
    }

    @Override
    public boolean contains(Object o) {
        return o == this;
    }

    @Override
    public IEivViewRecipe get(int index) {
        if (index != 0) {
            throw new IndexOutOfBoundsException("Index: " + index + ", Size: 1");
        }
        return this;
    }

    @Override
    public void forEach(Consumer<? super IEivViewRecipe> action) {
        action.accept(this);
    }

    @Override
    public boolean removeIf(Predicate<? super IEivViewRecipe> filter) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void replaceAll(UnaryOperator<IEivViewRecipe> operator) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void sort(Comparator<? super IEivViewRecipe> c) {
    }

    @Override
    public Spliterator<IEivViewRecipe> spliterator() {
        return new ViewSpliterator();
    }

    private static /* synthetic */ void lambda$bindChanceSlot$3(class_2561 text, class_1799 stack, List tooltip) {
        tooltip.add(1, text);
    }

    @Environment(value=EnvType.CLIENT)
    private class ViewIterator
    implements Iterator<IEivViewRecipe> {
        private boolean hasNext = true;

        private ViewIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.hasNext;
        }

        @Override
        public IEivViewRecipe next() {
            if (this.hasNext) {
                this.hasNext = false;
                return CreateView.this;
            }
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        @Override
        public void forEachRemaining(Consumer<? super IEivViewRecipe> action) {
            Objects.requireNonNull(action);
            if (this.hasNext) {
                this.hasNext = false;
                action.accept(CreateView.this);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private class ViewSpliterator
    implements Spliterator<IEivViewRecipe> {
        long est = 1L;

        private ViewSpliterator() {
        }

        @Override
        public Spliterator<IEivViewRecipe> trySplit() {
            return null;
        }

        @Override
        public boolean tryAdvance(Consumer<? super IEivViewRecipe> consumer) {
            Objects.requireNonNull(consumer);
            if (this.est > 0L) {
                --this.est;
                consumer.accept(CreateView.this);
                return true;
            }
            return false;
        }

        @Override
        public void forEachRemaining(Consumer<? super IEivViewRecipe> consumer) {
            this.tryAdvance(consumer);
        }

        @Override
        public long estimateSize() {
            return this.est;
        }

        @Override
        public int characteristics() {
            return 17745;
        }
    }
}

